<?php
require_once './.header.php';

if (isset($_POST['submit'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    $errors = [];

    // Validate current password
    if (empty($current_password)) {
        $errors[] = "Current password is required";
    }

    // Validate new password
    if (empty($new_password)) {
        $errors[] = "New password is required";
    } elseif (strlen($new_password) < 6) {
        $errors[] = "New password must be at least 6 characters long";
    }

    // Validate confirm password
    if (empty($confirm_password)) {
        $errors[] = "Confirm password is required";
    } elseif ($new_password !== $confirm_password) {
        $errors[] = "New password and confirm password do not match";
    }

    // If no errors, proceed with password change
    if (empty($errors)) {
        // Verify current password
        $admin_id = $_SESSION['admin_id'];
        $admin_detail = fetch_admin_detail($admin_id);

        if (password_verify($current_password, $admin_detail['password']) || $current_password === $admin_detail['password']) {
            // Update password
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

            $sql = "UPDATE admin SET password = ? WHERE admin_id = ?";
            $stmt = mysqli_prepare($link, $sql);
            mysqli_stmt_bind_param($stmt, "si", $hashed_password, $admin_id);

            if (mysqli_stmt_execute($stmt)) {
                $success_message = "Password updated successfully!";
            } else {
                $errors[] = "Error updating password: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        } else {
            $errors[] = "Current password is incorrect";
        }
    }
}
?>

<div class="app-wrapper">
    <div class="app-content pt-3 p-md-3 p-lg-4">
        <div class="container-xl">
            <div class="row g-3 mb-4 align-items-center justify-content-between">
                <div class="col-auto">
                    <h1 class="app-page-title mb-0">Change Password</h1>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="app-card app-card-settings shadow-sm p-4">
                        <div class="app-card-body">
                            <?php if (isset($success_message)): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo $success_message; ?>
                                </div>
                            <?php endif; ?>

                            <?php if (isset($errors) && !empty($errors)): ?>
                                <?php foreach ($errors as $error): ?>
                                    <div class="alert alert-danger" role="alert">
                                        <?php echo $error; ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>

                            <form method="post">
                                <div class="mb-3">
                                    <label for="current_password" class="form-label">Current Password</label>
                                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                                </div>

                                <div class="mb-3">
                                    <label for="new_password" class="form-label">New Password</label>
                                    <input type="password" class="form-control" id="new_password" name="new_password" required>
                                    <div class="form-text">Password must be at least 6 characters long.</div>
                                </div>

                                <div class="mb-3">
                                    <label for="confirm_password" class="form-label">Confirm New Password</label>
                                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                </div>

                                <button type="submit" name="submit" class="btn app-btn-primary">Update Password</button>
                                <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once './.footer.php'; ?>