<?php

/**
 * Get Issue Details - AJAX Handler
 * Returns issue details for the admin panel
 */

require_once './.fx.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if it's a GET request
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Get issue ID
$issue_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($issue_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid issue ID']);
    exit;
}

// Fetch issue details
$issue = fetch_issue($issue_id);

if ($issue) {
    echo json_encode([
        'success' => true,
        'issue' => $issue
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Issue not found'
    ]);
}
