<?php
require_once './.header.php';

// Handle status updates
if (isset($_POST['update_status'])) {
    $issue_id = $_POST['issue_id'];
    $status = $_POST['status'];
    $admin_notes = $_POST['admin_notes'];

    $result = update_issue_status($issue_id, $status, $admin_notes);
    if ($result) {
        echo '<script>alert("Issue status updated successfully");</script>';
    } else {
        echo '<script>alert("Error updating issue status");</script>';
    }
}

// Handle issue deletion
if (isset($_POST['delete_issue'])) {
    $issue_id = $_POST['issue_id'];
    $result = delete_issue($issue_id);
    if ($result) {
        echo '<script>alert("Issue deleted successfully"); window.location="issues.php";</script>';
        exit();
    } else {
        echo '<script>alert("Error deleting issue");</script>';
    }
}

// Get filter parameters
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$category_filter = isset($_GET['category']) ? $_GET['category'] : '';

// Fetch issues with filters
$issues = fetch_issues($status_filter, $category_filter);
?>

<div class="app-wrapper">
    <div class="app-content pt-3 p-md-3 p-lg-4">
        <div class="container-xl">
            <div class="row g-3 mb-4 align-items-center justify-content-between">
                <div class="col-auto">
                    <h1 class="app-page-title mb-0">Support Issues</h1>
                    <p class="text-muted">Manage and respond to user support issues</p>
                </div>
                <div class="col-auto">
                    <div class="page-utilities">
                        <div class="row g-2 justify-content-start justify-content-md-end align-items-center">
                            <div class="col-auto">
                                <form method="get" class="row g-2">
                                    <div class="col-auto">
                                        <select name="status" class="form-select form-select-sm">
                                            <option value="">All Status</option>
                                            <option value="pending" <?php echo $status_filter === 'pending' ? 'selected' : ''; ?>>Pending</option>
                                            <option value="in_progress" <?php echo $status_filter === 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                                            <option value="resolved" <?php echo $status_filter === 'resolved' ? 'selected' : ''; ?>>Resolved</option>
                                            <option value="closed" <?php echo $status_filter === 'closed' ? 'selected' : ''; ?>>Closed</option>
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <select name="category" class="form-select form-select-sm">
                                            <option value="">All Categories</option>
                                            <option value="Swap/Exchange" <?php echo $category_filter === 'Swap/Exchange' ? 'selected' : ''; ?>>Swap/Exchange</option>
                                            <option value="NFT Mint" <?php echo $category_filter === 'NFT Mint' ? 'selected' : ''; ?>>NFT Mint</option>
                                            <option value="Connect to Dapps" <?php echo $category_filter === 'Connect to Dapps' ? 'selected' : ''; ?>>Connect to Dapps</option>
                                            <option value="Login Issues" <?php echo $category_filter === 'Login Issues' ? 'selected' : ''; ?>>Login Issues</option>
                                            <option value="Missing Funds" <?php echo $category_filter === 'Missing Funds' ? 'selected' : ''; ?>>Missing Funds</option>
                                            <option value="High Fees" <?php echo $category_filter === 'High Fees' ? 'selected' : ''; ?>>High Fees</option>
                                            <option value="Migrate" <?php echo $category_filter === 'Migrate' ? 'selected' : ''; ?>>Migrate</option>
                                            <option value="Transaction Delay" <?php echo $category_filter === 'Transaction Delay' ? 'selected' : ''; ?>>Transaction Delay</option>
                                            <option value="Issues With Trading Wallet" <?php echo $category_filter === 'Issues With Trading Wallet' ? 'selected' : ''; ?>>Issues With Trading Wallet</option>
                                            <option value="Unable to Purchase Coins" <?php echo $category_filter === 'Unable to Purchase Coins' ? 'selected' : ''; ?>>Unable to Purchase Coins</option>
                                            <option value="Locked Account" <?php echo $category_filter === 'Locked Account' ? 'selected' : ''; ?>>Locked Account</option>
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <button type="submit" class="btn btn-primary btn-sm">Filter</button>
                                        <a href="issues.php" class="btn btn-secondary btn-sm">Clear</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-content" id="orders-table-tab-content">
                <div class="tab-pane fade show active" id="orders-all" role="tabpanel" aria-labelledby="orders-all-tab">
                    <div class="app-card app-card-orders-table shadow-sm mb-5">
                        <div class="app-card-body">
                            <div class="table-responsive">
                                <table class="table app-table-hover mb-0 text-left">
                                    <thead>
                                        <tr>
                                            <th class="cell">ID</th>
                                            <th class="cell">Category</th>
                                            <th class="cell">User</th>
                                            <th class="cell">Status</th>
                                            <th class="cell">Priority</th>
                                            <th class="cell">Date</th>
                                            <th class="cell">Ref #</th>
                                            <th class="cell">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if (!empty($issues)) {
                                            foreach ($issues as $issue) {
                                                $status_class = '';
                                                switch ($issue['status']) {
                                                    case 'pending':
                                                        $status_class = 'badge bg-warning';
                                                        break;
                                                    case 'in_progress':
                                                        $status_class = 'badge bg-info';
                                                        break;
                                                    case 'resolved':
                                                        $status_class = 'badge bg-success';
                                                        break;
                                                    case 'closed':
                                                        $status_class = 'badge bg-secondary';
                                                        break;
                                                }

                                                $priority_class = '';
                                                switch ($issue['priority']) {
                                                    case 'low':
                                                        $priority_class = 'badge bg-success';
                                                        break;
                                                    case 'medium':
                                                        $priority_class = 'badge bg-warning';
                                                        break;
                                                    case 'high':
                                                        $priority_class = 'badge bg-danger';
                                                        break;
                                                    case 'urgent':
                                                        $priority_class = 'badge bg-dark';
                                                        break;
                                                }
                                        ?>
                                                <tr>
                                                    <td class="cell"><?php echo $issue['issue_id']; ?></td>
                                                    <td class="cell"><?php echo htmlspecialchars($issue['issue_category']); ?></td>
                                                    <td class="cell">
                                                        <strong><?php echo htmlspecialchars($issue['user_name']); ?></strong><br>
                                                        <small><?php echo htmlspecialchars($issue['user_email']); ?></small>
                                                    </td>
                                                    <td class="cell">
                                                        <span class="<?php echo $status_class; ?>"><?php echo ucfirst(str_replace('_', ' ', $issue['status'])); ?></span>
                                                    </td>
                                                    <td class="cell">
                                                        <span class="<?php echo $priority_class; ?>"><?php echo ucfirst($issue['priority']); ?></span>
                                                    </td>
                                                    <td class="cell"><?php echo date('M d, Y H:i', strtotime($issue['submission_date'])); ?></td>
                                                    <td class="cell"><?php echo $issue['ref_number']; ?></td>
                                                    <td class="cell">
                                                        <button class="btn-sm app-btn-secondary" onclick="viewIssue(<?php echo $issue['issue_id']; ?>)">View</button>
                                                        <button class="btn-sm app-btn-secondary" onclick="editIssue(<?php echo $issue['issue_id']; ?>)">Edit</button>
                                                        <form method="post" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this issue?')">
                                                            <input type="hidden" name="issue_id" value="<?php echo $issue['issue_id']; ?>">
                                                            <button type="submit" name="delete_issue" class="btn-sm btn-danger">Delete</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                        <?php
                                            }
                                        } else {
                                            echo '<tr><td colspan="8" class="text-center">No issues found</td></tr>';
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Issue View Modal -->
<div class="modal fade" id="issueViewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Issue Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="issueViewContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Issue Edit Modal -->
<div class="modal fade" id="issueEditModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Issue</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" id="editIssueForm">
                    <input type="hidden" name="issue_id" id="edit_issue_id">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select" required>
                            <option value="pending">Pending</option>
                            <option value="in_progress">In Progress</option>
                            <option value="resolved">Resolved</option>
                            <option value="closed">Closed</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Admin Notes</label>
                        <textarea name="admin_notes" class="form-control" rows="4" placeholder="Add your notes here..."></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="update_status" class="btn btn-primary">Update Issue</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function viewIssue(issueId) {
        // Load issue details via AJAX
        fetch('get_issue.php?id=' + issueId)
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const issue = data.issue;
                    const content = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Issue Information</h6>
                            <p><strong>Category:</strong> ${issue.issue_category}</p>
                            <p><strong>Status:</strong> ${issue.status}</p>
                            <p><strong>Priority:</strong> ${issue.priority}</p>
                            <p><strong>Reference:</strong> ${issue.ref_number}</p>
                            <p><strong>Submitted:</strong> ${issue.submission_date}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>User Information</h6>
                            <p><strong>Name:</strong> ${issue.user_name}</p>
                            <p><strong>Email:</strong> ${issue.user_email}</p>
                            <p><strong>Phone:</strong> ${issue.user_phone || 'Not provided'}</p>
                        </div>
                    </div>
                    <hr>
                    <h6>Issue Description</h6>
                    <p>${issue.issue_description}</p>
                    ${issue.wallet_address ? `<p><strong>Wallet Address:</strong> ${issue.wallet_address}</p>` : ''}
                    ${issue.transaction_hash ? `<p><strong>Transaction Hash:</strong> ${issue.transaction_hash}</p>` : ''}
                    ${issue.amount_involved ? `<p><strong>Amount Involved:</strong> ${issue.amount_involved}</p>` : ''}
                    ${issue.admin_notes ? `<hr><h6>Admin Notes</h6><p>${issue.admin_notes}</p>` : ''}
                `;
                    document.getElementById('issueViewContent').innerHTML = content;
                    new bootstrap.Modal(document.getElementById('issueViewModal')).show();
                }
            });
    }

    function editIssue(issueId) {
        document.getElementById('edit_issue_id').value = issueId;
        new bootstrap.Modal(document.getElementById('issueEditModal')).show();
    }
</script>

<?php require_once './.footer.php'; ?>