<?php
/**
 * Simple Email Function for QFS Admin Panel
 * Uses PHP's built-in mail() function as a fallback when PHPMailer is not available
 */

function send_simple_mail($to, $subject, $body) {
    // Email headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: QFS Admin Panel <noreply@qfs.com>" . "\r\n";
    $headers .= "Reply-To: noreply@qfs.com" . "\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    
    // Send email using PHP's built-in mail function
    $result = mail($to, $subject, $body, $headers);
    
    return $result;
}

/**
 * Test email functionality
 */
function test_email_function() {
    $to = "admin@qfs.com";
    $subject = "Test Email - QFS Admin Panel";
    $body = "
    <html>
    <head>
        <title>Test Email</title>
    </head>
    <body>
        <h2>Test Email</h2>
        <p>This is a test email from the QFS Admin Panel.</p>
        <p>If you receive this email, the email functionality is working correctly.</p>
        <p>Time: " . date('Y-m-d H:i:s') . "</p>
    </body>
    </html>
    ";
    
    return send_mail($to, $subject, $body);
}
?> 