<?php
/**
 * Submit Issue Handler
 * Processes issue submissions from the index page modal
 */

require_once 'admin/.fx.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Process the form submission
$response = add_issue($_POST);

if (is_array($response) && isset($response['success']) && $response['success']) {
    // Success
    echo json_encode([
        'success' => true,
        'ref_number' => $response['ref_number'],
        'message' => 'Issue submitted successfully'
    ]);
} else {
    // Error
    echo json_encode([
        'success' => false,
        'message' => is_array($response) ? $response : 'An error occurred while submitting your issue'
    ]);
}
?> 